import Image from "next/image";
import React, { Dispatch, SetStateAction, useState } from "react";

type BankComboBoxProps = {
  selectValue: string;
  bankError: boolean;
  setSelectValue: Dispatch<SetStateAction<string>>;
};

type OptionType = {
  id: number;
  text: string;
  value: string;
  default?: boolean;
};
export default function BankComboBox({
  selectValue,
  bankError,
  setSelectValue,
}: BankComboBoxProps) {
  const [selectText, setSelectText] = useState<string>("");
  const [isOpen, setIsOpen] = useState<boolean>(false);

  const selectOptions: OptionType[] = [
    {
      id: 0,
      text: "انتخاب کنید",
      value: "-1",
      default: true,
    },
    { id: 1, text: "بانک ملی", value: "Melli" },
    { id: 2, text: "بانک ملت", value: "Mellat" },
    { id: 3, text: "بانک صادرات", value: "Saderat" },
    { id: 4, text: "بانک تجارت", value: "Tejarat" },
    { id: 5, text: "بانک سپه", value: "Sepah" },
    { id: 6, text: "بانک کشاورزی", value: "Keshavarzi" },
    { id: 7, text: "بانک مسکن", value: "Maskan" },
    { id: 8, text: "بانک رفاه", value: "Refah" },
    { id: 9, text: "بانک پاسارگاد", value: "Pasargad" },
    { id: 10, text: "بانک پارسیان", value: "Parsian" },
    { id: 11, text: "بانک سامان", value: "Saman" },
    { id: 12, text: "بانک اقتصاد نوین", value: "Eghtesad_Novin" },
    { id: 13, text: "بانک شهر", value: "Shahr" },
    { id: 14, text: "بانک کارآفرین", value: "Karafarin" },
    { id: 15, text: "بانک آینده", value: "Ayandeh" },
    { id: 16, text: "بانک صنعت و معدن", value: "Sanat_Madan" },
    { id: 17, text: "بانک سینا", value: "Sina" },
    { id: 18, text: "بانک ایران زمین", value: "Iran_Zamin" },
    { id: 19, text: "بانک سرمایه", value: "Sarmayeh" },
    { id: 20, text: "بانک ملل", value: "Melall" },
    { id: 21, text: "بانک رسالت", value: "Resalat" },
    { id: 22, text: "پست بانک", value: "Postbank" },
    { id: 23, text: "بانک خاورمیانه", value: "Khavar_Mianeh" },
    { id: 24, text: "بانک انصار", value: "Ansar" },
    { id: 25, text: "بانک قوامین", value: "Ghavamin" },
    { id: 26, text: "بانک حکمت", value: "Hekmat" },
    { id: 27, text: "بانک کوثر", value: "Kosar" },
    { id: 28, text: "بانک مهر اقتصاد", value: "Mehr_Eghtesad" },
    { id: 29, text: "بانک مهر ایران", value: "Mehr_Iran" },
    { id: 30, text: "بانک نور", value: "Noor" },
    { id: 31, text: "بانک مرکزی", value: "Bank_Markazi" },
    { id: 32, text: "بانک کاسپین", value: "Caspian" },
    { id: 33, text: "بانک دی", value: "Dey" },
    { id: 34, text: "بانک گردشگری", value: "Gardeshgari" },
    { id: 35, text: "بانک ایران اروپا", value: "Iran_Europe" },
    { id: 36, text: "بانک ایران ونزوئلا", value: "Iran_Venezuela" },
    { id: 37, text: "بانک استاندارد چارترد", value: "Standard_Chartered" },
    { id: 38, text: "بانک فیوچر", value: "Futurebank" },
    { id: 39, text: "بانک تعاون اسلامی", value: "Taavon_Eslami" },
    { id: 40, text: "بانک توسعه", value: "Tosee" },
    { id: 41, text: "بانک توسعه صادرات", value: "Tosee_Saderat" },
    { id: 42, text: "بانک توسعه تعاون", value: "Tosee_Taavon" },
  ];
  const selectHanlder = (opt: OptionType) => {
    if (opt.value === "-1") {
      setIsOpen(false);
      return;
    }
    setSelectValue(opt.value);
    setSelectText(opt.text);
    setIsOpen(false);
  };
  return (
    <div className="child:text-[#696464] dark:child:text-light">
      <p className="font text-lg">نام بانک :</p>
      <div className="relative w-full h-[53px] mt-2.25 bg-[#EFEFEF] dark:bg-dark-500 text-base-mines rounded-sm outline-none">
        <div
          className="w-full h-full p-4 pl-10 cursor-pointer"
          onClick={() => setIsOpen((prev) => !prev)}
        >
          {selectText ? (
            <div className="flex items-center gap-x-2.5">
              <Image
                src={`/images/banks/${selectValue}.svg`}
                width={40}
                height={40}
                alt={selectText}
                className="w-5 h-5"
              />

              <p>{selectText}</p>
            </div>
          ) : (
            "انتخاب کنید"
          )}
        </div>
        <div
          className={`${
            isOpen
              ? "absolute top-[60px] right-0 w-full h-[210px] p-2.5 bg-[#EFEFEF] dark:bg-dark-500 overflow-auto scrollbar-custom "
              : "hidden"
          } `}
          onMouseLeave={() => setIsOpen(false)}
        >
          {selectOptions.map((opt) => (
            <div
              key={opt.id}
              className="flex items-center gap-x-2.5 space-y-1.5 p-1 hover:bg-light dark:hover:bg-dark-200 cursor-pointer duration-150"
              onClick={() => selectHanlder(opt)}
            >
              {opt.value !== "-1" && (
                <Image
                  src={`/images/banks/${opt.value}.svg`}
                  width={40}
                  height={40}
                  alt={opt.text}
                  className="w-5 h-5"
                />
              )}
              <p className="pb-1">{opt.text}</p>
            </div>
          ))}
        </div>
      </div>

      {bankError && !selectValue && (
        <div className="flex items-center gap-2.5 w-full mt-2.5 child:text-[#FF0000] text-xs">
          <svg className="size-5 shrink-0">
            <use href="#danger"></use>
          </svg>
          <p className="text-wrap whitespace-normal">بانک خود را انتخاب کنید</p>
        </div>
      )}
    </div>
  );
}
