"use client";
import { GiftType } from "@/@types/gift";
import { getReferral } from "@/services/referral";
import { useQuery } from "@tanstack/react-query";
import React from "react";

export default function TransactionTable() {
  const { data: referrals } = useQuery({
    queryKey: ["user-referral"],
    queryFn: getReferral,
    select: (res) => res.data,
  });

  return (
    <table className="w-full mt-7">
      <thead>
        <tr className="child:text-center child:text-[#A5A5A5] child:text-sm">
          <th>مبلغ هدیه دریافتی</th>
          <th>کد معرفی</th>
          {/* <th>توضیحات</th> */}
          <th>تاریخ دریافت</th>
        </tr>
      </thead>
      <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
        {referrals?.logGift ? (
          referrals?.logGift?.item?.map((item: GiftType) => (
            <tr
              key={item?._id}
              className=" child:py-[30px] child:px-2 child:text-center child:grow child:min-w-[200px] lg:child:w-[20%]"
            >
              <td>
                <div className="flex items-center justify-center gap-1.75 text-[#081035] dark:text-light">
                  <p className="font-peyda font-extrabold text-base xl:text-lg text-center">
                    {item?.price?.toLocaleString()}
                  </p>
                  <p className="font-peyda font-medium text-base xl:text-base text-center">
                    تومان
                  </p>
                </div>
              </td>
              <td className="text-wrap whitespace-normal text-[#1D1C1A] dark:text-light">
                <p className="text-center text-base">{item?.coderef}</p>
              </td>
              {/* <td className="">
                <p className="text-[#858585] dark:text-light/80 font-medium text-sm">
                  -
                </p>
              </td> */}
              <td className="text-wrap whitespace-normal text-[#1D1C1A] dark:text-light">
                <p className="text-center text-base">
                  {new Date(referrals?.logGift?.createdAt)?.toLocaleDateString(
                    "fa-IR"
                  )}
                </p>
              </td>
            </tr>
          ))
        ) : (
          <tr>
            <td colSpan={4} className="text-center py-10 text-[#EE404C]">
              دیتایی یافت نشد
            </td>
          </tr>
        )}
      </tbody>
    </table>
  );
}
