"use client";

import React from "react";
import { Button } from "@/components/ui/button";
import { useForm } from "react-hook-form";
import { yupResolver } from "@hookform/resolvers/yup";
import { UserAuthenticationSchema } from "@/configs/ValidationSchema";
type input = {
  id: number;
  label: string;
  required: boolean;
  inputType: string;
  value: "password" | "confirmPassword";
};
type UserAuthenticationType = {
  password: string;
  confirmPassword: string;
};
export default function UserAuthentication() {
  //   {
  //   userInfo,
  // }: {
  //   userInfo: UserInfoType | null}
  const {
    register,
    handleSubmit,
    formState: { errors },
  } = useForm<UserAuthenticationType>({
    resolver: yupResolver(UserAuthenticationSchema),
    defaultValues: {
      password: "",
      confirmPassword: "",
    },
  });

  const authInputs: input[] = [
    {
      id: 1,
      label: "رمز عبور :",
      required: false,
      inputType: "password",
      value: "password",
    },
    {
      id: 2,
      label: "تکرار رمز عبور :",
      required: true,
      inputType: "password",
      value: "confirmPassword",
    },
  ];
  // const submitHandler = (data: UserAuthenticationType) => {};
  const submitHandler = () => {};
  return (
    <section className="w-full mt-6 py-6 px-[29px] bg-light dark:bg-[#393939]">
      <form className="w-full" onSubmit={handleSubmit(submitHandler)}>
        <div>
          <p className="font-bold text-xl text-[#001A46] dark:text-light">
            امنیت و احراز هویت
          </p>
          <div className="flex items-center mt-4">
            <span className="w-[17%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[83%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <div className="grid  grid-cols-1 md:grid-cols-2  xl:grid-cols-3 gap-x-7 xl:gap-x-10 gap-y-7 xl:gap-y-[32px] mt-10">
          {authInputs.map((input) => (
            <div
              key={input.id}
              className="child:text-[#696464] dark:child:text-light"
            >
              <p className="font text-lg">
                {input.label}{" "}
                {input.required ? (
                  <span className="text-error-400">*</span>
                ) : (
                  ""
                )}
              </p>
              <input
                className="w-full h-[53px] mt-2.25 bg-[#EFEFEF] dark:bg-dark-500 p-4 text-base-mines rounded-sm"
                type={input.inputType}
                placeholder="وارد کنید"
                {...register(input.value)}
              />
              {errors[input.value] && (
                <div className="flex items-center gap-2.5 w-full mt-2.5 child:text-[#FF0000] text-xs">
                  <svg className="size-5 shrink-0">
                    <use href="#danger"></use>
                  </svg>
                  <p className="text-wrap whitespace-normal">
                    {errors[input.value]?.message}
                  </p>
                </div>
              )}
            </div>
          ))}
          <div className="w-full mt-auto">
            <Button
              className="hidden sm:inline-block flex-center w-full h-[53px] px-5 bg-secondary-default hover:bg-secondary-default/90 text-base dark:text-light rounded"
              type="submit"
            >
              ذخیره
            </Button>
          </div>
        </div>
      </form>
    </section>
  );
}
