import React from "react";

import UserInfoForm from "./UserInfoForm";
import { cookies } from "next/headers";
import { redirect } from "next/navigation";
import UserAuthentication from "./UserAuthentication";
import UserAddressForm from "./UserAddressForm";

export default async function UserInfo() {
  let userInfo = null;
  try {
    const token = cookies().get("accessToken")?.value;
    const res = await fetch(`${process.env.NEXT_PUBLIC_BASE_URL}user/profile`, {
      method: "GET",
      headers: {
        authorization: `Bearer ${token ? token : ""}`,
      },
    });
    userInfo = await res.json();
  } catch {
    return redirect("/user-panel");
  }

  return (
    <>
      <UserInfoForm userInfo={userInfo?.user} />
      <UserAuthentication />
      <UserAddressForm userAddressInfo={userInfo?.user} />
    </>
  );
}
