import { TicketsType } from "@/@types/tickets";
import Link from "next/link";
import React from "react";

type TicketsTableProps = {
  _id: string;
  uuid: number;
  title: string;
  userid: string;
  date: string;
  lastdate: string;
  category: string;
  status: "open" | "close";
};

export default function TicketsTable({
  tickets,
}: {
  tickets: TicketsTableProps[];
}) {
  return (
    <table className="w-full mt-7">
      <thead>
        <tr className="child:text-right child:text-[#454545] dark:child:text-light/80 child:text-sm">
          <th className="pb-3.25 border-b border-dark/[7%] dark:border-light/[6%]">
            موضوع تیکت
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            دسته بندی
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            تاریخ ثبت
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            تاریخ آخرین تغیرات
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            وضعیت
          </th>
          <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
            عملیات
          </th>
        </tr>
      </thead>
      <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
        {tickets?.map((ticket: TicketsType) => (
          <tr
            key={ticket._id}
            className=" child:py-[30px] child:px-2 child:text-right child:grow child:min-w-[200px] lg:child:w-[20%]"
          >
            <td>
              <div className="flex items-center gap-2 xl:gap-[18px]">
                <p className="text-[#575757] dark:text-light/80 text-sm">
                  {ticket.title}
                </p>
              </div>
            </td>
            <td>
              <p className="text-[#575757] dark:text-light/80 text-base text-center">
                {ticket?.category === "1" ? "پشتیبانی محصول" : ticket?.category}
              </p>
            </td>
            <td>
              <p className="text-[#575757] dark:text-light/80 text-base text-center">
                {new Date(ticket.date).toLocaleDateString("fa-IR")}
              </p>
            </td>
            <td>
              <p className="text-[#575757] dark:text-light/80 text-base text-center">
                {new Date(ticket.lastdate).toLocaleDateString("fa-IR")}
              </p>
            </td>
            <td>
              <p
                className={`${
                  ticket.status === "open" ? "text-[#00B074]" : "text-[#FF0000]"
                } text-center text-base`}
              >
                {ticket.status === "open" ? "باز" : "بسته شده"}
              </p>
            </td>
            <td className="">
              <Link
                className="flex-center p-2.5 bg-secondary-default hover:bg-secondary-default/90 duration-150 child:text-white rounded-md"
                href={`/user-panel/tickets/${ticket._id}`}
              >
                <p>مشاهده</p>
              </Link>
            </td>
          </tr>
        ))}
      </tbody>
    </table>
  );
}
