"use client";
import React from "react";

import { getWishList } from "@/services/wishlist";
import { useQuery } from "@tanstack/react-query";
import LoadingBox from "@/components/modules/LoadingBox";
import { WishType } from "@/@types/wish";
import WishRow from "@/components/modules/WishRow";

type WishItemType = {
  fileid: WishType[];
  _id: string;
};

export default function WishlistTable() {
  const { data: wishList, isLoading } = useQuery({
    queryKey: ["wishList"],
    queryFn: getWishList,
    select: (res) => res.data,
  });

  if (isLoading) return <LoadingBox />;

  return (
    <table className="w-full mt-7">
      <thead>
        <tr className="child:text-center child:text-[#A5A5A5] child:text-sm">
          <th>عنوان محصول</th>
          <th>دسته بندی</th>
          <th>تاریخ</th>
          <th>عملیات</th>
        </tr>
      </thead>
      {wishList?.data?.length > 0 ? (
        <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
          {wishList?.data?.map((item: WishItemType) => (
            <WishRow
              key={item?.fileid[0]?._id}
              data={item?.fileid[0]}
              wishId={item._id}
            />
          ))}
        </tbody>
      ) : (
        <tbody>
          <tr>
            <td colSpan={4} className="text-center py-10 text-[#EE404C]">
              دیتایی یافت نشد
            </td>
          </tr>
        </tbody>
      )}
    </table>
  );
}
