"use client";
import React, { useContext, useState } from "react";
import Image from "next/image";
import { Button } from "../ui/button";
import LogoutModal from "../modules/LogoutModal";
import Link from "next/link";
import { SidebarContext } from "@/app/context/ShowSidebarContext";
import { OrderCountContext } from "@/app/context/OrderCountProvider";
import NotificationBox from "./NotificationBox";

export default function UserLayoutHeader() {
  const [isOpenLogoutModal, setIsOpenLogoutModal] = useState<boolean>(false);

  const ShowSideBarContext = useContext(SidebarContext);
  const counterContextData = useContext(OrderCountContext);

  function toggleDarkModeClass() {
    document.documentElement.classList.toggle("dark");
  }

  return (
    <div className="flex items-center justify-between w-full pt-3 pb-3.5 pr-2.75 pl-[33px] bg-light dark:bg-[#393939] ">
      <Link href="/" className="hidden lg:inline-block w-[189px] h-[66px]">
        <Image
          src={"/images/user-panel-logo.svg"}
          width={189}
          height={66}
          alt="عکس لوگو سایت دارکوبیت"
          className="w-full h-full"
        />
      </Link>

      <svg
        className=" inline-block lg:hidden size-6 shrink-0 text-neutral-200/90 dark:text-light cursor-pointer"
        onClick={() => ShowSideBarContext?.setIsShowSidebar(true)}
      >
        <use href="#squares2*2"></use>
      </svg>
      <div className="flex items-center gap-[18px] ">
        <Button
          className="hidden sm:inline-block flex-center bg-secondary-default hover:bg-secondary-default/90 dark:text-light rounded-default"
          onClick={toggleDarkModeClass}
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 24 24"
            strokeWidth={1.5}
            stroke="currentColor"
            className="size-6"
          >
            <path
              strokeLinecap="round"
              strokeLinejoin="round"
              d="M12 3v2.25m6.364.386-1.591 1.591M21 12h-2.25m-.386 6.364-1.591-1.591M12 18.75V21m-4.773-4.227-1.591 1.591M5.25 12H3m4.227-4.773L5.636 5.636M15.75 12a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0Z"
            />
          </svg>
        </Button>
        <Link
          href={"/orders"}
          className="flex items-center gap-4 px-3 xl:px-6 py-2.25 bg-dark-400 dark:bg-dark-500 rounded-20"
        >
          <p className="flex items-center justify-center size-4 pt-0.5 bg-light/20 text-white rounded-full px-1">
            {counterContextData?.orderCount}
          </p>
          <svg className="size-6 text-light">
            <use href="#shop"></use>
          </svg>
        </Link>
        <NotificationBox />
        <div
          className="group flex-center size-[34px] bg-[#acacac] dark:bg-[#2D2D2A] rounded-full cursor-pointer"
          onClick={() => setIsOpenLogoutModal(true)}
        >
          <svg className="size-5 text-light group-hover:text-red-500 duration-150">
            <use href="#power"></use>
          </svg>
        </div>
      </div>
      {isOpenLogoutModal && (
        <LogoutModal setIsOpenLogoutModal={setIsOpenLogoutModal} />
      )}
    </div>
  );
}
