import * as yup from "yup";

const nameRegex = /^[ء-غف-یپچژکگههٔی]+(?:\s[ء-غف-یپچژکگههٔی]+)*$/;
const usernameRegex = /^[A-Za-z0-9]+$/;
const phoneRegex = /^09\d{9}$/;
const homePhoneRegex = /^0\d{2,3}-?\d{7,8}$/;
const nationalCodeRegex = /^\d{10}$/;
const postalCodeRegex = /^\d{10}$/;

const phoneNumberSchema = yup.object({
  phone: yup
    .string()
    .required("شماره موبایل خود را وارد کنید")
    .matches(
      /((0?9)|(\+?989))\d{2}\W?\d{3}\W?\d{4}/g,
      "شماره موبایل معتبر نمی باشد."
    )
    .max(11, "شماره موبایل معتبر نمی باشد."),
});

const otpNumberSchema = yup.object({
  otp: yup
    .string()
    .required("کد تایید خود را وارد کنید")
    .min(6, "کد تأیید معتبر نمی باشد.")
    .max(6, "کد تأیید معتبر نمی باشد."),
});
const userRegisterSchema = yup.object({
  phone: yup
    .string()
    .required("شماره موبایل خود را وارد کنید")
    .matches(
      /((0?9)|(\+?989))\d{2}\W?\d{3}\W?\d{4}/g,
      "شماره موبایل معتبر نمی باشد."
    )
    .min(11, "شماره موبایل معتبر نمی باشد.")
    .max(11, "شماره موبایل معتبر نمی باشد."),
  username: yup
    .string()
    .trim()
    .required("نام کاربری خود را وارد کنید")
    .min(3, "نام کاربری معتبر نمی باشد.")
    .max(20, "نام کاربری معتبر نمی باشد.")
    .matches(
      usernameRegex,
      "نام کاربری باید فقط شامل حروف انگلیسی و اعداد باشد"
    ),
  email: yup
    .string()
    .required("ایمیل خود را وارد کنید")
    .matches(
      /[^@ \t\r\n]+@[^@ \t\r\n]+\.[^@ \t\r\n]+/g,
      "ایمیل معتبر نمی باشد."
    ),
  password: yup
    .string()
    .required("رمز عبور خود را وارد کنید")
    .min(8, "رمز عبور باید بیتشتر از 8 کاراکتر باشد")
    .max(20, "رمز عبور باید کمتر از 20 کاراکتر باشد"),

  fname: yup
    .string()
    .trim()
    .required("نام خود را وارد کنید")
    .min(3, "نام شما معتبر نمی باشد.")
    .max(20, "نام شما معتبر نمی باشد.")
    .matches(nameRegex, "نام باید فقط شامل حروف فارسی باشد"),
  lname: yup
    .string()
    .trim()
    .required("نام خانوادگی خود را وارد کنید")
    .min(3, "نام خانوادگی شما معتبر نمی باشد.")
    .max(20, "نام خانوادگی شما معتبر نمی باشد.")
    .matches(nameRegex, "نام خانوادگی باید فقط شامل حروف فارسی باشد"),
  refCode: yup.string().trim().default(""),
});
const passwordLoginSchema = yup.object({
  phone: yup
    .string()
    .required("شماره موبایل خود را وارد کنید")
    .matches(
      /((0?9)|(\+?989))\d{2}\W?\d{3}\W?\d{4}/g,
      "شماره موبایل معتبر نمی باشد."
    )
    .max(11, "شماره موبایل معتبر نمی باشد."),
  password: yup
    .string()
    .required("رمز عبور خود را وارد کنید")
    .min(8, "رمز عبور باید بیتشتر از 8 کاراکتر باشد")
    .max(20, "رمز عبور باید کمتر از 20 کاراکتر باشد"),
});
const userAuthSchema = yup.object({
  gender: yup.string().default(""),
  city: yup.string().default(""),
  homephone: yup.string().default(""),
  province: yup.string().default(""),
  datebirth: yup.string().default(""),
  fname: yup
    .string()
    .trim()
    .required("نام خود را وارد کنید")
    .min(3, "نام شما معتبر نمی باشد.")
    .max(20, "نام شما معتبر نمی باشد.")
    .matches(nameRegex, "نام باید فقط شامل حروف فارسی باشد"),
  lname: yup
    .string()
    .trim()
    .required("نام خانوادگی خود را وارد کنید")
    .min(3, "نام خانوادگی شما معتبر نمی باشد.")
    .max(20, "نام خانوادگی شما معتبر نمی باشد.")
    .matches(nameRegex, "نام خانوادگی باید فقط شامل حروف فارسی باشد"),
  address: yup.string().default(""),
  postalcode: yup
    .string()
    .default("")
    .matches(
      /\b(?!(\d)\1{3})[13-9]{4}[1346-9][013-9]{5}\b/,
      "کد پستی معتبر نمی باشد"
    ),
  avatar: yup.string().default(""),
  website: yup.string().default(""),
  email: yup
    .string()
    .required("ایمیل خود را وارد کنید")
    .matches(
      /[^@ \t\r\n]+@[^@ \t\r\n]+\.[^@ \t\r\n]+/g,
      "ایمیل معتبر نمی باشد."
    ),
  nationalCode: yup.string().default(""),
});
const userInfoSchema = yup.object({
  username: yup.string().default("").trim(),
  email: yup
    .string()
    .required("ایمیل خود را وارد کنید")
    .matches(
      /[^@ \t\r\n]+@[^@ \t\r\n]+\.[^@ \t\r\n]+/g,
      "ایمیل معتبر نمی باشد."
    ),
  codemeli: yup
    .string()
    .trim()
    .matches(/^[0-9]{10}$/, {
      message: "کد ملی معتبر نمی باشد",
      excludeEmptyString: true,
    })
    .default(""),
  fname: yup
    .string()
    .trim()
    .required("نام خود را وارد کنید")
    .min(3, "نام شما معتبر نمی باشد.")
    .max(20, "نام شما معتبر نمی باشد.")
    .matches(nameRegex, "نام باید فقط شامل حروف فارسی باشد"),
  lname: yup
    .string()
    .trim()
    .required("نام خانوادگی خود را وارد کنید")
    .min(3, "نام خانوادگی شما معتبر نمی باشد.")
    .max(20, "نام خانوادگی شما معتبر نمی باشد.")
    .matches(nameRegex, "نام خانوادگی باید فقط شامل حروف فارسی باشد"),
  gender: yup
    .string()
    .oneOf(["مرد", "زن"], "جنسیت باید مرد یا زن باشد")
    .default("مرد"),
  datebirth: yup.string().default(""),
  avatar: yup.string().default(""),
});

const UserAuthenticationSchema = yup.object({
  password: yup
    .string()
    .required("رمز عبور خود را وارد کنید")
    .min(8, "رمز عبور باید بیتشتر از 8 کاراکتر باشد")
    .max(20, "رمز عبور باید کمتر از 20 کاراکتر باشد"),
  confirmPassword: yup
    .string()
    .required("رمز عبور خود را وارد کنید")
    .min(8, "رمز عبور باید بیتشتر از 8 کاراکتر باشد")
    .max(20, "رمز عبور باید کمتر از 20 کاراکتر باشد"),
});
const userAddressSchema = yup.object({
  website: yup.string().default("").trim(),
  homephone: yup
    .string()
    .default("")
    .trim()
    .matches(/^0\d{2,3}-?\d{7,8}$/, {
      message: "شماره ثابت معتبر نمی باشد.",
      excludeEmptyString: true,
    }),
  postalcode: yup
    .string()
    .trim()
    .matches(/\b(?!(\d)\1{3})[13-9]{4}[1346-9][013-9]{5}\b/, {
      message: "کد پستی معتبر نمی باشد",
      excludeEmptyString: true,
    })
    .default(""),
  city: yup.string().default("").trim(),
  province: yup.string().default("").trim(),
  address: yup.string().default(""),
  phone: yup
    .string()
    .trim()
    .matches(/((0?9)|(\+?989))\d{2}\W?\d{3}\W?\d{4}/g, {
      message: "شماره موبایل معتبر نمی باشد.",
      excludeEmptyString: true,
    })
    .max(11, "شماره موبایل معتبر نمی باشد.")
    .default(""),
});
const devInfoSchema = yup.object({
  title: yup.string().trim().required("عنوان فروشگاه خود را وارد کنید").trim(),
  bio: yup
    .string()
    .trim()
    .required("توضیحات فروشگاه خود را وارد کنید")
    .trim()
    .max(1000, "متن شما نباید بیشتر از 500 کاراکتر باشد"),
  website: yup.string().trim().required("لینک وبسایت خود را وارد کنید").trim(),
  email: yup.string().trim().required("ایمیل خود را وارد کنید").trim(),
  // phone: yup
  //   .string()
  //   .trim()
  //   .required("شماره موبایل خود را وارد کنید")
  //   .matches(
  //     /((0?9)|(\+?989))\d{2}\W?\d{3}\W?\d{4}/g,
  //     "شماره موبایل معتبر نمی باشد."
  //   )
  //   .max(11, "شماره موبایل معتبر نمی باشد."),
});
const ticketSchema = yup.object({
  category: yup.string().required("دسته بندی سوال خود را انتخاب کنید"),
  priority: yup.string().required("الویت سوال خود را انتخاب کنید"),
  text: yup.string().required("پیام خود را بنویسید"),
  title: yup.string().required("موضوع تیکت را بنویسید"),
});
const ticketInputSchema = yup.object({
  text: yup.string().trim().required("متن پیام خود را وارد کنید").trim(),
});

const bankShema = yup.object({
  accountHolder: yup
    .string()
    .required("نام و نام خانوادگی خود را وارد کند")
    .matches(nameRegex, "نام و نام خانوادگی باید فقط شامل حروف فارسی باشد")
    .trim(),
  shaba: yup
    .string()
    .required("شماره شبا خود را وارد کند")
    .max(26, "شماره شبا صحیح نمی باشد")
    .matches(/IR[0-9]{24}/, "شماره شبا صحیح نمی باشد"),
  cardNumber: yup
    .string()
    .required("شماره کارت خود را وارد کند")
    .max(16, "شماره کارت صحیح نمی باشد")
    .matches(/[2569]{1}[\d]{15}/, "شماره کارت معتبر نمی باشد"),

  bankName: yup.string().required("اسم بانک خود را انتخاب کنید"),
});

const devDiscountSchema = yup.object({
  code: yup.string().required("کد تخفیف را وارد کنید"),
  amount: yup.string().required("میزان درصد کد تخفیف را وارد کنید"),
  usageLimit: yup
    .string()
    .required("تعداد کل استفاده از کد تخفیف را وارد کنید"),
  expiry: yup.string().required("تاریخ انقضا کد تخفیف رو وارد کنید"),
});
const contactFormSchema = yup.object({
  fullname: yup
    .string()
    .trim()
    .required("نام خود را وارد کنید")
    .min(3, "نام شما معتبر نمی باشد.")
    .max(20, "نام شما معتبر نمی باشد.")
    .matches(nameRegex, "نام باید فقط شامل حروف فارسی باشد"),
  email: yup
    .string()
    .trim()
    .email("لطفا یک ایمیل معتبر وارد کنید")
    .required("ایمیل خود را وارد کنید")
    .trim(),
  phone: yup
    .string()
    .trim()
    .required("شماره موبایل خود را وارد کنید")
    .matches(
      /((0?9)|(\+?989))\d{2}\W?\d{3}\W?\d{4}/g,
      "شماره موبایل معتبر نمی باشد."
    )
    .max(11, "شماره موبایل معتبر نمی باشد."),
  department: yup.string().required("واحد مورد نظر را انتخاب کنید"),
  message: yup.string().required(" متن خود را وارد کند"),
});
const commentSchema = yup.object({
  message: yup.string().required("متن پیام را وارد کنید"),
});
const FileSchema = yup.object({
  title: yup.string().required("عنوان را وارد کنید"),
  subdecs: yup.string().required("توضیحات کوتاه محصول  را وارد کنید"),
  decs: yup.string().required("توضحیات محصول را وارد کنید"),
  price: yup.string().required("قیمت محصول را وارد کنید"),
  categoryid: yup.string().required("دسته بندی محصول را وارد کنید"),
  subcategoryid: yup.string().required("زیر دسته محصول را وارد کنید"),
  previewlink: yup
    .string()
    .nullable()
    .notRequired()
    .transform((value) => (value == null ? "" : value))
    .default(""),
  isaccept: yup.boolean().required("وضعیت تایید را مشخص کنید"),
  features: yup
    .array(
      yup.object({
        name: yup.string().trim(),
        detail: yup.string().trim(),
      })
    )
    .default([]),

  customOptions: yup
    .array(
      yup.object({
        title: yup.string().trim(),
        value: yup.string().trim(),
      })
    )
    .default([]),
});
const categorySchema = yup.object({
  title: yup.string().required("نام دسته بندی را وارد کنید"),
  href: yup
    .string()
    .required("مسیر دسته بندی را وارد کنید")
    .matches(
      /^[a-zA-Z0-9-_]+$/,
      "فقط از حروف انگلیسی، اعداد، خط تیره (-) و زیرخط (_) استفاده کنید"
    ),
});

const editUserSchema = yup.object({
  username: yup.string().required("نام کاربری را وارد کنید"),
  fname: yup.string().required("نام را وارد کنید"),
  lname: yup.string().required("نام خانوادگی را وارد کنید"),
  phone: yup
    .string()
    .matches(/^(\+98|0)?9\d{9}$/, "شماره موبایل معتبر نیست")
    .required("شماره موبایل را وارد کنید"),
  codemeli: yup
    .string()
    .matches(/^\d{10}$/, "کد ملی معتبر نیست")
    .required("کدملی را وارد کنید"),
  email: yup.string().email("ایمیل معتبر نیست").required("ایمیل را وارد کنید"),
  address: yup.string().required("آدرس را وارد کنید"),
  gender: yup.string().required("جنسیت را وارد کنید"),
  datebirth: yup.string().required("تاریخ تولد را وارد کنید"),
  isAuthentication: yup.boolean().default(false).required(),
  isflag: yup.boolean().default(false).required(),
  isdev: yup.boolean().default(false).required(),
  password: yup.string().default(""),
  website: yup.string().default(""),
  homephone: yup.string().default(""),
  postalcode: yup.string().default(""),
  province: yup.string().default(""),
  city: yup.string().default(""),
  role: yup
    .string()
    .oneOf(["USER", "ADMIN", "SEO"], "نفش کاربر صحیح نمی باشد")
    .required("لطفا نقش کاربر را انتخاب کنید"),
});

const discountSchema = yup.object({
  code: yup.string().required("  کد تخفیف را وارد کنید"),
  amount: yup.string().required("  میزان کد تخفیف را وارد کنید"),
  expiry: yup.string().required("  تاریخ اتمام کد تخفیف را وارد کنید"),
  usageLimit: yup.string().required("  تعداد کل استفاده کد تخفیف را وارد کنید"),
});
const blogSchema = yup.object({
  title: yup.string().required("عنوان را وارد کنید"),
  alt: yup.string().required("توضیحات عکس (alt) را وارد کنید"),
  dec: yup.string().required("توضیحات کوتاه مقاله  را وارد کنید"),
  MetaTitle: yup.string().required("متا تایتل را وارد کنید"),
  keywords: yup.string().required("کلمات کلیدی مقاله را وارد کنید"),
  MetaDescription: yup.string().required("متا دیسکریپشن مقاله را وارد کنید"),
  href: yup.string().required("این فیلد الزامی است"),
  show: yup.boolean().required(),
});

const addUserSchema = yup
  .object({
    username: yup
      .string()
      .required("نام کاربری الزامی است")
      .matches(
        usernameRegex,
        "نام کاربری فقط باید شامل حروف انگلیسی و اعداد باشد"
      ),

    fname: yup
      .string()
      .required("نام الزامی است")
      .matches(nameRegex, "نام فقط باید شامل حروف فارسی باشد"),

    lname: yup
      .string()
      .required("نام خانوادگی الزامی است")
      .matches(nameRegex, "نام خانوادگی فقط باید شامل حروف فارسی باشد"),

    phone: yup
      .string()
      .required("شماره موبایل الزامی است")
      .matches(phoneRegex, "شماره موبایل معتبر نیست"),

    codemeli: yup
      .string()
      .required("کد ملی الزامی است")
      .matches(nationalCodeRegex, "کد ملی معتبر نیست"),

    email: yup.string().required("ایمیل الزامی است").email("ایمیل معتبر نیست"),

    address: yup.string().required("آدرس الزامی است"),

    gender: yup
      .mixed<"male" | "female">()
      .oneOf(["male", "female"], "جنسیت معتبر نیست")
      .required("جنسیت الزامی است"),

    datebirth: yup.string().required("تاریخ تولد الزامی است"),

    password: yup
      .string()
      .required("رمز عبور الزامی است")
      .min(8, "رمز عبور باید حداقل ۸ کاراکتر باشد")
      .matches(/[0-9]/, "رمز عبور باید حداقل یک عدد داشته باشد")
      .matches(/[a-zA-Z]/, "رمز عبور باید حداقل یک حرف داشته باشد"),

    // ---- OPTIONAL FIELDS ---- //

    website: yup
      .string()
      .nullable()
      .url("آدرس وبسایت معتبر نیست")
      .transform((v) => (v === "" ? undefined : v))
      .default(undefined),

    homephone: yup
      .string()
      .nullable()
      .matches(homePhoneRegex, "شماره تلفن منزل معتبر نیست")
      .transform((v) => (v === "" ? undefined : v))
      .default(undefined),

    postalcode: yup
      .string()
      .nullable()
      .matches(postalCodeRegex, "کد پستی معتبر نیست")
      .transform((v) => (v === "" ? undefined : v))
      .default(undefined),

    province: yup
      .string()
      .nullable()
      .min(2, "نام استان معتبر نیست")
      .transform((v) => (v === "" ? undefined : v))
      .default(undefined),

    city: yup
      .string()
      .nullable()
      .min(2, "نام شهر معتبر نیست")
      .transform((v) => (v === "" ? undefined : v))
      .default(undefined),
  })
  .partial();

const addNotificationSchema = yup.object({
  title: yup.string().required("عنوان نوتفیکیشن الزامی است"),
  description: yup.string().required("توضیحات نوتفیکیشن الزامی است"),
});

export {
  phoneNumberSchema,
  otpNumberSchema,
  userRegisterSchema,
  passwordLoginSchema,
  userAuthSchema,
  userInfoSchema,
  UserAuthenticationSchema,
  userAddressSchema,
  devInfoSchema,
  ticketSchema,
  ticketInputSchema,
  bankShema,
  devDiscountSchema,
  contactFormSchema,
  commentSchema,
  FileSchema,
  categorySchema,
  editUserSchema,
  discountSchema,
  blogSchema,
  addUserSchema,
  addNotificationSchema,
};
