"use client";
const setAccessToken = async (token: string) => {
  const maxAge = 6 * 24 * 60 * 60;
  document.cookie = `accessToken=${token}; path=/; max-age=${maxAge}`;
};

const getAccessToken = () => {
  if (typeof document === "undefined") return null;
  const token = document.cookie;
  let userToken: null | string = null;
  if (token) {
    const tokenSplit = token?.split(";");
    const accessTokenSplit = tokenSplit[0]?.split("=")?.[1];

    userToken = accessTokenSplit ? accessTokenSplit : null;
  }
  return userToken;
};
const logoutHandler = () => {
  let logoutStatus = false;
  const userLocaleData = localStorage.getItem("userInfo");
  if (userLocaleData) {
    localStorage.removeItem("userInfo");
    document.cookie = `accessToken=; path=/; max-age=-1`;
    logoutStatus = true;
  }
  localStorage.clear();
  return logoutStatus;
};

export { setAccessToken, getAccessToken, logoutHandler };
