import { api } from "@/configs/api";

const getUserFiles = () => api.get("/user/file");

const getFiles = () => api.get("admin/file");
const getFileDetails = (id: string) => api.get(`admin/file/${id}`);
const sendAdminFile = ({
  data,
  onProgress,
}: {
  data: FormData;
  onProgress?: (percent: number) => void;
}) => {
  return api.post("/admin/create/file", data, {
    headers: {
      "Content-Type": "multipart/form-data",
    },
    onUploadProgress: (progressEvent) => {
      if (!progressEvent.total) return;

      const percent = Math.round(
        (progressEvent.loaded * 100) / progressEvent.total
      );

      onProgress?.(percent);
    },
  });
};
const updateAdminFile = ({
  id,
  data,
  onProgress,
}: {
  id: string;
  data: FormData;
  onProgress?: (percent: number) => void;
}) => {
  return api.put(`/admin/update/file/${id}`, data, {
    headers: {
      "Content-Type": "multipart/form-data",
    },
    onUploadProgress: (progressEvent) => {
      if (!progressEvent.total) return;

      const percent = Math.round(
        (progressEvent.loaded * 100) / progressEvent.total
      );

      onProgress?.(percent);
    },
  });
};
const updateAdminFileStatus = ({
  id,
  isaccept,
}: {
  id: string;
  isaccept: boolean;
}) => api.put(`admin/update/file/${id}`, { isaccept });
const deleteFile = (id: string) => api.delete(`/admin/delete/file/${id}`);

const getDevFiles = () => api.get("admin/file");
const deleteDevFile = (id: string) => api.delete(`/admin/delete/file/${id}`);

const sendDevFile = ({
  data,
  onProgress,
}: {
  data: FormData;
  onProgress?: (percent: number) => void;
}) => {
  return api.post("/admin/create/file", data, {
    headers: {
      "Content-Type": "multipart/form-data",
    },
    onUploadProgress: (progressEvent) => {
      if (!progressEvent.total) return;

      const percent = Math.round(
        (progressEvent.loaded * 100) / progressEvent.total
      );

      onProgress?.(percent);
    },
  });
};

export {
  getUserFiles,
  getFiles,
  getFileDetails,
  sendAdminFile,
  updateAdminFile,
  updateAdminFileStatus,
  deleteFile,
  getDevFiles,
  deleteDevFile,
  sendDevFile,
};
