import { api } from "@/configs/api";

const getNotification = () => api.get("admin/notif");
const deleteNotification = (id: string) => api.delete(`admin/notif/${id}`);
const addNotification = (data: {
  title: string;
  description: string;
  member: "all" | "user";
  userid: string[] | "";
}) => api.post("admin/notif", data);

const editNotification = (data: {
  title: string;
  description: string;
  member: "all" | "user";
  userid: string[] | "";
  id: string;
}) =>
  api.put(`/admin/notif/${data?.id}`, {
    title: data?.title,
    description: data?.description,
    member: data?.member,
    userid: data?.userid,
  });

const getUserNotification = () => api.get("user/notif/me");

export {
  getNotification,
  deleteNotification,
  addNotification,
  editNotification,
  getUserNotification,
};
