import { api } from "@/configs/api";

const getProducts = (searchParams: string) =>
  api.get(`products${searchParams}`);

const getProducts1 = () => api.get(`files`);

const getSearchProducts = (query: string) => api.get(`search?q=${query}`);

const getProduct = ({ title, id }: { title: string; id: string }) =>
  api.get(`/file/${title}/${id}`);

const getProductByCategory = (id: string) =>
  api.get(`/file/category?key=${id}`);

const getLatestProducts = () => api.get("/file/new");

export {
  getProducts,
  getProducts1,
  getSearchProducts,
  getProduct,
  getProductByCategory,
  getLatestProducts,
};
