import { api } from "@/configs/api";

const sendOrder = (
  data: { productid: string; price: number; count: number }[]
) => api.post("user/basket/add", { products: data });

const updateOrder = (
  data: { productid: string; price: number; count: number }[]
) => api.put("/user/basket/update", { products: data });

const getOrders = () => api.get("/user/basket");
const getUserOrders = () => api.get("/user/order");

// const deleteOrder = (id: string) => api.delete(``);
export { sendOrder, updateOrder, getOrders, getUserOrders };
