import { api } from "@/configs/api";

const getProducts = () => api.get("file");
const getProduct = ({ title, id }: { title: string; id: string }) =>
  api.get(`/file/${title}/${id}`);
const getProductByCategory = (id: string) =>
  api.get(`/file/category?key=${id}`);
const getLatestProducts = () => api.get("/file/new");

export { getProducts, getProduct, getProductByCategory, getLatestProducts };
