import { api } from "@/configs/api";

const getWithdrawal = () => api.get("/user/withdrawal");

const sendWithdrawal = (data: { bankid: string; amount: number }) =>
  api.post("/user/withdrawal/create", data);

const getAdminWithdrawal = () => api.get("/admin/withdrawal");
const updateWithdrawal = (id: string) =>
  api.put(`/admin/withdrawal/status/${id}`);

export { sendWithdrawal, getWithdrawal, getAdminWithdrawal, updateWithdrawal };
