import { AddUserType, EditUserFormType } from "@/@types/user";
import { api } from "@/configs/api";

const getUsers = () => api.get("admin/userlist");

const updateUsersRole = (id: string) => api.get(`admin/changerole/${id}`);
const updateUserInfo = ({
  id,
  userInfo,
}: {
  id: string;
  userInfo: EditUserFormType;
}) => api.put(`/admin/user/${id}`, userInfo);

const addUser = (data: AddUserType) => api.post("admin/user/create", data);

export { getUsers, updateUsersRole, updateUserInfo, addUser };
